/*:
 * @target MZ
 * 
 * @help
 * 装備画面 コマンド選択をスキップする
 */
(() => {
  'use strict';

  function Scene_Equip_SkipCommandMixIn(sceneEquip) {
    const _create = sceneEquip.create;
    sceneEquip.create = function () {
      _create.call(this);
      /**
       * コマンドウィンドウを非アクティブにし、スロットウィンドウの先頭を選択してアクティブ化する
       */
      this._commandWindow.deactivate();
      this._slotWindow.select(0);
      this._slotWindow.activate();
    };

    /**
     * コマンドウィンドウは不要なのでサイズを0にする
     */
    sceneEquip.commandWindowRect = function () {
      return new Rectangle(0, this.mainAreaTop(), 0, 0);
    };

    const _createSlotWindow = sceneEquip.createSlotWindow;
    sceneEquip.createSlotWindow = function () {
      _createSlotWindow.call(this);
      /**
       * キャンセルとアクター切替の操作を設定
       */
      this._slotWindow.setHandler('cancel', () => this.popScene());
      this._slotWindow.setHandler('pagedown', () => this.nextActor());
      this._slotWindow.setHandler('pageup', () => this.previousActor());
    };

    const _onActorChange = sceneEquip.onActorChange;
    sceneEquip.onActorChange = function () {
      _onActorChange.call(this);
      /**
       * コマンドウィンドウを非アクティブにし、スロットウィンドウの先頭を選択してアクティブ化する
       */
      this._commandWindow.deactivate();
      this._slotWindow.select(0);
      this._slotWindow.activate();
    };
  }

  Scene_Equip_SkipCommandMixIn(Scene_Equip.prototype);
})();