//=============================================================================
// ForceEventNotThrough.js
//=============================================================================

/*:ja
 * @plugindesc イベントのすり抜け設定を無視して強制的にすり抜け不可にします。
 *
 * @help
 * このプラグインには、プラグインコマンドはありません。
 * イベントのメモに <NtEvents:x> と記載するとそのイベントはイベントID x をすり抜けできないイベントとして扱います。
 * 複数のイベントをすり抜け禁止する場合は必要な数だけ , で区切って指定します。例） <NtEvents:1,3,5>
 * <NtEvents:x> と記載したイベントをすり抜け設定した場合もイベントID x はすり抜けしません。
 */
 
(() => {
    "use strict";

    const _Game_Event_initialize = Game_Event.prototype.initialize;
    Game_Event.prototype.initialize = function() {
        _Game_Event_initialize.apply(this, arguments);
        this._NtEvents = typeof this.event().meta.NtEvents !== "undefined" ? this.event().meta.NtEvents.split(",") : [];
    };

    Game_Event.prototype.NtEventsXy = function(x, y) {
		return $gameMap.eventsXy(x, y).filter(e => this._NtEvents.includes(String(e.eventId())));
    }

    Game_Event.prototype.isThroughXy = function(x, y) {
        return this._through && (this.NtEventsXy(x, y).length === 0);
    };

    Game_Event.prototype.canPass = function(x, y, d) {
        var x2 = $gameMap.roundXWithDirection(x, d);
        var y2 = $gameMap.roundYWithDirection(y, d);
        if (!$gameMap.isValid(x2, y2)) {
            return false;
        }
        if (this.isThroughXy(x2, y2) || this.isDebugThrough()) {
            return true;
        }
        if (!this.isMapPassable(x, y, d)) {
            return false;
        }
        if (this.isCollidedWithCharacters(x2, y2)) {
            return false;
        }
        return true;
    };

    Game_Event.prototype.isCollidedWithEvents = function(x, y) {
        const events = $gameMap.eventsXyNt(x, y).concat(this.NtEventsXy(x, y));
        return events.length > 0;
    };
})();