//=============================================================================
// main.js v1.3.0
//=============================================================================

const scriptUrls = [
    "cheat/init/import.js",
    "js/libs/pixi.js",
    "js/libs/pako.min.js",
    "js/libs/localforage.min.js",
    "js/libs/effekseer.min.js",
    "js/libs/vorbisdecoder.js",
    "js/rmmz_core.js",
    "js/rmmz_managers.js",
    "js/rmmz_objects.js",
    "js/rmmz_scenes.js",
    "js/rmmz_sprites.js",
    "js/rmmz_windows.js",
    "js/plugins.js"
];
const effekseerWasmUrl = "js/libs/effekseer.wasm";

class Main {
    constructor() {
        this.xhrSucceeded = false;
        this.loadCount = 0;
        this.error = null;
    }

    run() {
        this.showLoadingSpinner();
        this.testXhr();
        this.loadMainScripts();
    }

    showLoadingSpinner() {
        const loadingSpinner = document.createElement("div");
        const loadingSpinnerImage = document.createElement("div");
        loadingSpinner.id = "loadingSpinner";
        loadingSpinnerImage.id = "loadingSpinnerImage";
        loadingSpinner.appendChild(loadingSpinnerImage);
        document.body.appendChild(loadingSpinner);
    }

    eraseLoadingSpinner() {
        const loadingSpinner = document.getElementById("loadingSpinner");
        if (loadingSpinner) {
            document.body.removeChild(loadingSpinner);
        }
    }

    testXhr() {
        const xhr = new XMLHttpRequest();
        xhr.open("GET", document.currentScript.src);
        xhr.onload = () => (this.xhrSucceeded = true);
        xhr.send();
    }

    loadMainScripts() {
        for (const url of scriptUrls) {
            const script = document.createElement("script");
            script.type = "text/javascript";
            script.src = url;
            script.async = false;
            script.defer = true;
            script.onload = this.onScriptLoad.bind(this);
            script.onerror = this.onScriptError.bind(this);
            script._url = url;
            document.body.appendChild(script);
        }
        this.numScripts = scriptUrls.length;
        window.addEventListener("load", this.onWindowLoad.bind(this));
        window.addEventListener("error", this.onWindowError.bind(this));
    }

    onScriptLoad() {
        if (++this.loadCount === this.numScripts) {
            PluginManager.setup($plugins);
        }
    }

    onScriptError(e) {
        this.printError("Failed to load", e.target._url);
    }

    printError(name, message) {
        this.eraseLoadingSpinner();
        if (!document.getElementById("errorPrinter")) {
            const errorPrinter = document.createElement("div");
            errorPrinter.id = "errorPrinter";
            errorPrinter.innerHTML = this.makeErrorHtml(name, message);
            document.body.appendChild(errorPrinter);
        }
    }

    makeErrorHtml(name, message) {
        const nameDiv = document.createElement("div");
        const messageDiv = document.createElement("div");
        nameDiv.id = "errorName";
        messageDiv.id = "errorMessage";
        nameDiv.innerHTML = name;
        messageDiv.innerHTML = message;
        return nameDiv.outerHTML + messageDiv.outerHTML;
    }

    onWindowLoad() {
        if (!this.xhrSucceeded) {
            const message = "Your browser does not allow to read local files.";
            this.printError("Error", message);
        } else if (this.isPathRandomized()) {
            const message = "Please move the Game.app to a different folder.";
            this.printError("Error", message);
        } else if (this.error) {
            this.printError(this.error.name, this.error.message);
        } else {
            this.initEffekseerRuntime();
        }
    }

    onWindowError(event) {
        if (!this.error) {
            this.error = event.error;
        }
    }

    isPathRandomized() {
        // [Note] We cannot save the game properly when Gatekeeper Path
        //   Randomization is in effect.
        return (
            Utils.isNwjs() &&
            process.mainModule.filename.startsWith("/private/var")
        );
    }

    initEffekseerRuntime() {
        const onLoad = this.onEffekseerLoad.bind(this);
        const onError = this.onEffekseerError.bind(this);
        effekseer.initRuntime(effekseerWasmUrl, onLoad, onError);
    }

    onEffekseerLoad() {
        this.eraseLoadingSpinner();
        SceneManager.run(Scene_Boot);
    }

    onEffekseerError() {
        this.printError("Failed to load", effekseerWasmUrl);
    }
}

const main = new Main();
main.run();

//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Thêm vàng
function addGold(amount) { 
    if (typeof $gameParty !== "undefined") {
        $gameParty.gainGold(amount); 
        console.log("Gold +", amount);
    } else {
        console.error("Game chưa khởi động, không thể thêm Gold!");
    }
}

// Hồi phục toàn bộ HP/MP cho tất cả nhân vật
function fullRecovery() { 
    if (typeof $gameParty !== "undefined") {
        $gameParty.members().forEach(actor => actor.recoverAll()); 
        console.log("Tất cả nhân vật đã hồi phục HP/MP!");
    } else {
        console.error("Game chưa khởi động, không thể hồi phục!");
    }
}

// Tăng chỉ số (stat) cho tất cả nhân vật
function increaseStat(stat, value) {
    if (typeof $gameParty !== "undefined") {
        $gameParty.members().forEach(actor => {
            switch (stat.toLowerCase()) { // Chuyển về chữ thường để đồng nhất
                case 'hp': 
                    actor.addParam(0, value); // MaxHP
                    break;
                case 'mp': 
                    actor.addParam(1, value); // MaxMP
                    break;
                case 'atk': 
                    actor.addParam(2, value); // Attack
                    break;
                case 'def': 
                    actor.addParam(3, value); // Defense
                    break;
                case 'agi': 
                    actor.addParam(6, value); // Agility
                    break;
                case 'luck': 
                    actor.addParam(7, value); // Luck
                    break;
                default:
                    console.error("Chỉ số không hợp lệ!");
                    return;
            }
        });
        console.log(stat.toUpperCase() + " +" + value);
    } else {
        console.error("Game chưa khởi động, không thể tăng chỉ số!");
    }
}

// Tăng level cho tất cả nhân vật
function increaseLevel(levels) {
    if (typeof $gameParty !== "undefined") {
        $gameParty.members().forEach(actor => {
            actor.changeLevel(actor.level + levels, false); // Không hiện thông báo level up
        });
        console.log("Tất cả nhân vật +", levels, "level!");
    } else {
        console.error("Game chưa khởi động, không thể tăng level!");
    }
}