function exportData() {

function exportAllLocalforageData() {
    const iframe = document.getElementById('game-inner-frame');
    if (!iframe || !iframe.contentWindow || !iframe.contentWindow.localforage) {
        console.error('Iframe or localforage not accessible.');
        return;
    }

    const iframeWindow = iframe.contentWindow;

    iframeWindow.localforage.keys().then(function(keys) {
        let allData = {};

        const promises = keys.map(function(key) {
            return iframeWindow.localforage.getItem(key).then(function(value) {
                allData[key] = value;
            });
        });

        Promise.all(promises).then(function() {
            const jsonData = JSON.stringify(allData);
            const base64 = btoa(unescape(encodeURIComponent(jsonData)));

            // Check if running in Android WebView with saveDataManager
            if (typeof saveDataManager !== 'undefined' && typeof saveDataManager.saveAsJson === 'function') {
                // Android bridge
                saveDataManager.saveAsJson(base64);
            } else {
                // Web browser fallback
                const dataUrl = 'data:application/json;base64,' + base64;
                const link = document.createElement('a');
                link.href = dataUrl;
                const filename = document.title || 'SavesData';
                link.download = `${filename}_SavesData.json`;
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            }
        }).catch(function(error) {
            console.error('Error processing iframe localforage data:', error);
        });
    }).catch(function(error) {
        console.error('Error retrieving keys from iframe localforage:', error);
    });
}


// Call this function to export all localforage data from iframe
exportAllLocalforageData();




}

function importData() {
function importLocalForageFromJson(event) {
    const file = event.target.files[0];
    if (!file) return;

    const iframe = document.getElementById('game-inner-frame');
    if (!iframe || !iframe.contentWindow || !iframe.contentWindow.localforage) {
        console.error('Iframe or localforage not accessible.');
        alert('Failed to access the game iframe.');
        return;
    }

    const iframeWindow = iframe.contentWindow;

    const reader = new FileReader();
    reader.onload = function(e) {
        try {
            const jsonData = JSON.parse(e.target.result);

            const importPromises = [];

            for (const key in jsonData) {
                if (jsonData.hasOwnProperty(key)) {
                    importPromises.push(
                        iframeWindow.localforage.setItem(key, jsonData[key])
                            .then(() => console.log(`Imported: ${key}`))
                            .catch((err) => console.error(`Error importing ${key}:`, err))
                    );
                }
            }

            Promise.all(importPromises).then(() => {
                alert('Save data has been successfully imported! Please reload the game to apply changes.');
            });

        } catch (error) {
            console.error('Error parsing JSON:', error);
            alert('Failed to import data. Please ensure the file is a valid JSON file.');
        }
    };

    reader.readAsText(file);
}

 
// Add an input element to the page for importing the JSON file
function createImportButton() {
    const inputElement = document.createElement('input');
    inputElement.type = 'file';
    inputElement.accept = '.json';  // Only allow .json files
    inputElement.addEventListener('change', importLocalForageFromJson);
 
    inputElement.style.zIndex = 100;  // Set z-index to 100
    inputElement.style.position = 'absolute';  // Position the button as needed
    inputElement.style.top = '50%';  // Center the button vertically
    inputElement.style.left = '50%';  // Center the button horizontally
    inputElement.style.transform = 'translate(-50%, -50%)';
    
    // Add the input element to the page (for example, append to body)
    const body = document.body;
    body.insertBefore(inputElement, body.firstChild);
 
    inputElement.click();
    
    setTimeout(function() {
        inputElement.remove();
    }, 5000);
        
}
 
// Trigger the import button on page load
createImportButton();
 

    
}