varying vec2 v_texCoord;
varying vec4 v_fragmentColor;

const float PI = 3.1415926;

uniform vec4 u_outlineColor;
uniform float u_radius;
uniform bool u_knockout;
uniform int u_quality;

int quality_max = 80;

//角度,距離,原点の座標 から座標を求めーる
vec2 degree2point(float radius,float degree,vec2 orig)
{
    float radian = degree * PI / 180.0;
    float x = sin(radian) * radius;
    float y = cos(radian) * radius;
    return orig + vec2(x, y);
}


void main(void)
{
    vec4 normal = vec4(0.0);
    vec4 outline = vec4(0.0);
    vec4 final = vec4(0.0);
    
    normal = texture2D(CC_Texture0, vec2(v_texCoord.x, v_texCoord.y));
    
    //
    int quality = u_quality;
    for (int i=0; i<=quality_max ;i++){
        outline += texture2D(CC_Texture0, degree2point(u_radius,360.0/float(quality)*float(i),v_texCoord));
        //
        if(quality == i){break;}
        //一部android端末で、ループの条件式にuniformを設定できない(らしい)ので
        //breakで無理くり終わらせています
    }
    //
    
    outline.a = smoothstep(0.0,1.0,outline.a);//0.0~1.0にまるめる
    
    outline.a = outline.a * u_outlineColor.a;//透明度
    outline.rgb = u_outlineColor.rgb * outline.a;//着色
    
    //ノックアウト(塗りつぶすか否か)
    if (u_knockout == false){
        normal = (outline * (1.0 - normal.a)) + (normal * normal.a);
        final = normal;
    }else{
        final = outline;
    }
    
    gl_FragColor = final;
}
