varying vec2        v_texCoord;
uniform sampler2D   u_texture;
uniform vec2        u_texSize;
uniform vec2        u_texPos;
uniform int         u_mosaicLevel;
uniform sampler2D   u_maskTexture;

void main() {
    vec4 mask = texture2D(u_maskTexture, v_texCoord);
    
    vec2 target;
    target.x = float(int(v_texCoord.x / float(u_mosaicLevel) * u_texSize.x + 0.5)) * float(u_mosaicLevel) / u_texSize.x;
    target.y = float(int(v_texCoord.y / float(u_mosaicLevel) * u_texSize.y + 0.5)) * float(u_mosaicLevel) / u_texSize.y;
    
    gl_FragColor = texture2D(u_texture, mask.a > 0.5 ? target : v_texCoord);
}
