
varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

uniform float u_h;
uniform float u_s;
uniform float u_v;

vec3 rgb2hsv(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}


void main(void)
{
    vec4 c = texture2D(CC_Texture0, v_texCoord);
    vec4 final = c;

    vec3 rgb = vec3(c.r, c.g, c.b);
    vec3 hsv = rgb2hsv(rgb);
    
    hsv.x = clamp(hsv.x + u_h - 0.5, 0.0, 1.0);//色相
    hsv.y = clamp(hsv.y + u_s - 0.5, 0.0, 1.0);//彩度
    hsv.z = clamp(hsv.z + u_v * 2.0 - 1.0, -1.0, 1.0); //明度(ミスってそう3)

    vec3 nrgb = hsv2rgb(hsv);

    final.rgb = nrgb.xyz;
    final.a = c.a;

    gl_FragColor = final;
}
