const https = require('http')
const fs = require('fs')
const zlib = require("zlib"); 

const port = 80
const ip = '127.0.0.1'
const cachePath = './gamedata'

const options = {
    rejectUnauthorized: false
  };

  token = ""
  
  async function login(userid,username,password) {
      let loginURL = `https://api.pinkcafeart.com/auth/check`
      jsontest = `{"user_id":"${userid}","user_name":"${username}","password":"${password}"}`
      let response = await fetch(loginURL, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: jsontest
      })
      data = await response.json();
      console.log(data);
      token = data.token
      return data.token
  }
  

function handlerAuthCheck(req, res) {
    let json = JSON.parse(req.body)
    login(json.user_id,json.user_name,json.password).then(
      function (value) {
          console.log(value)
          token = value
          msg = `{"auth":true,"authed_token":"${value}","tier":4,"user_name":"${json.user_name}"}`
          res.writeHead(200, {
              'Content-Type': 'application/json; charset=utf-8',
              'Content-Length': msg.length
          })
          res.end(msg)
      },
      function (error) {
          console.log(error)
      }
  );
}

function handlerGamedataMap(req, res) {
    let json = JSON.parse(req.body)
    let path = `${cachePath}/${json.scenario}/${json.version}/map/${json.map}.tmx`
    let upstreamURL = `https://api.pinkcafeart.com/gamedata/map`
    if (fs.existsSync(path)) {
        console.log(`serving ${json.map}.tmx using cached file`)
        fs.createReadStream(path).pipe(res)
    } else {
        jsontest = `{"token":"${token}","scenario":"${json.scenario}","version":"${json.version}","map":"${json.map}"}`
        fetch(upstreamURL, {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json'
            },
            body: jsontest
          })
          .then(response => {
            if (!response.ok) {
              throw new Error('Network response was not ok');
            }
            return response.text();
          })
          .then(data => {
            fs.writeFile(path, data, (err) => {
                if (err) {
                  console.error('Error writing file:', err);
                } else {
                  console.log('File saved successfully.');
                }
              });
            console.log(data);
          })
          .catch(error => {
            console.error('There was a problem with the fetch operation:', error);
          });
    setTimeout(function(){
        if (fs.existsSync(path)) {
            console.log(`serving ${json.map}.tmx using cached file`)
            fs.createReadStream(path).pipe(res)

        }
           else
           {
            fs.createReadStream(`${cachePath}/${json.scenario}/14/map/0010001.tmx`).pipe(res)
           }
    }, 2000);
    }
}

function get(url, callback) {
    https.get(url, res => {
        res.body = ''
        res.on('data', chunk => res.body += chunk)
        res.on('end', () => callback(res))
    })
}

https.createServer(options, (req, res) => {
    if (req.method === 'POST') {
        req.body = ''
        req.on('data', chunk => req.body += chunk)
        req.on('end', () => {
            // console.log(req.headers)
            console.log(`\n${req.method} ${req.url}\n${req.body}`)
            let msg
            let obj = JSON.parse(req.body)
            switch (req.url) {
                case '////////////auth/check':
                    handlerAuthCheck(req, res)
                    break
                case '////////////gamedata/map':
                    handlerGamedataMap(req, res)
                    break
                default:
                    console.log('unimplemented')
                    res.end('unimplemented')
            }
        })
    } else {
    if (req.method === 'GET') {
            console.log(`\n${req.method} ${req.url}\n${req.body}`)
            switch (req.url) {
                case '////////////master?type=HoneyVillage':
                    console.log(`Sending client the update list`)
                    fs.createReadStream('./Master/master.xml').pipe(res)
                    break
                case '////////////master?type=Common':
                    console.log(`Sending client the update list`)
                    fs.createReadStream('./Master/master.xml').pipe(res)
                    break
		case '////////////gamedata/map':
                    console.log('Sending client the map.')
      		    fs.createReadStream('./gamedata/04_fantasy/10/map/0010001.tmx').pipe(res)
                    break
                default:
                    console.log(`\n${req.method} ${req.url}: unimplemented`)
                    res.end()
        }
      }
    } 
}).listen(port, ip)

console.log(`server listening on ${ip}:${port}`)

